from __future__ import generators
import plus
import AI
from AI import vector3
import Arenas
import Gooey
import math
import Tactics

class Judge(AI.SuperAI):
    "AI for a servo motor-powered hammer with a piston on the end for extra power on the downswing.  Works for frenZy or beta-syle electric hammer bots too."
    name = "Judge"
    # Use variable 'StartAngle' to set the angle the hammer will revert to when not in use.  Usually will be 0, +/- math.pi/2, or +/- math.pi.
    # Use variable 'MotorID' to tell the AI which component is the hammer motor.
    # The 'reload' variable is used differently here than in Omni.  Here 'reload' is how long (in ticks) the AI should wait for the hammer to complete its swing before retracting it.  A slower hammer will need a longer reload.  Default is 4.

    def __init__(self, **args):
        AI.SuperAI.__init__(self, **args)
               
        self.zone = "weapon"
        self.triggers = ["Fire"]
        self.trigger2 = ["Srimech"]
        self.reloadTime = 0
        self.reloadDelay = 4
        self.motor = 8
        self.startangle = math.pi
        self.spin_range = 3.0
        self.tolerance = math.pi/8
        self.beta = 0
        self.wheels = []
        
        if 'range' in args:
            self.spin_range = args.get('range')
      
        if 'triggers' in args: self.triggers = args['triggers']
        if 'reload' in args: self.reloadDelay = args['reload']
        if 'MotorID' in args: self.motor = args.get('MotorID')
        if 'StartAngle' in args: self.startangle = args.get('StartAngle')
        if 'Tolerance' in args: self.startangle = args.get('Tolerance')
        if 'beta' in args: self.beta = args.get('beta')
        
        self.triggerIterator = iter(self.triggers)
 
        if 'tactic' in args: 
            self.theTactic = args['tactic']
            if   self.theTactic  == "Charge" : self.tactics.append(Tactics.Charge(self))
            elif self.theTactic  == "Ram" : self.tactics.append(Tactics.Ram(self))
            elif self.theTactic  == "Shove" : self.tactics.append(Tactics.Shove(self))
            elif self.theTactic  == "Engage" : self.tactics.append(Tactics.Engage(self))
            else: self.tactics.append(Tactics.Engage(self))
        else: self.tactics.append(Tactics.Engage(self))
        
    def Activate(self, active):
        if active:
            if AI.SuperAI.debugging:
                self.debug = Gooey.Plain("watch", 0, 75, 100, 75)
                tbox = self.debug.addText("line0", 0, 0, 100, 15)
                tbox.setText("Throttle")
                tbox = self.debug.addText("line1", 0, 15, 100, 15)
                tbox.setText("Turning")
                tbox = self.debug.addText("line2", 0, 30, 100, 15)
                tbox.setText("")
                tbox = self.debug.addText("line3", 0, 45, 100, 15)
                tbox.setText("")
            if self.spin_range == math.pi*100:
                plus.emitSmoke(100, (plus.getLocation(self.GetID())), (0, 0, 0), (5, 5, 5))
                CompList = plus.describe(self.GetID())
                for comp in xrange(0,CompList.count(" ")): plus.show(self.GetID(),comp,0)
            
            self.RegisterSmartZone(self.zone, 1)
            
        return AI.SuperAI.Activate(self, active)

    def Tick(self):
        # apply downward force for Beta to simulate magnetic wheels
        self.wheels = [x for x in plus.getContacts(self.GetID()) if x == 1]
        if self.beta < 0 and len(self.wheels) >= 2:
            plus.force(self.GetID(), 0, self.beta, 0)
        # fire weapon
        if self.weapons:

            # spin up depending on enemy's range
            enemy, range = self.GetNearestEnemy()
            
            if enemy is not None and range < self.spin_range:
                self.Input("Spin", 0, 1)
            elif self.GetInputStatus("Spin", 0) != 0:
                self.Input("Spin", 0, 0)
            
            targets = [x for x in self.sensors.itervalues() if x.contacts > 0 \
                and not plus.isDefeated(x.robot)]
            
            # retract hammer after it has had time for a full swing
            if self.reloadTime <= 0 and abs(self.GetMotorAngle(self.motor) - self.startangle) > self.tolerance:
                self.Input("Hammer", 0, -100)
            # fire hammer ONLY if fully retracted
            if (len(targets) > 0 or self.IsUpsideDown()) and abs(self.GetMotorAngle(self.motor) - self.startangle) <= self.tolerance:
                try:
                    trigger = self.triggerIterator.next()
                except StopIteration:
                    self.triggerIterator = iter(self.triggers)
                    trigger = self.triggerIterator.next()
                
                self.Input(trigger, 0, 1)
                self.Input("Hammer", 0, 100)
                self.reloadTime = self.reloadDelay
            # stop trying to retract the hammer once it is fully retracted
            if self.reloadTime <= 0 and abs(self.GetMotorAngle(self.motor) - self.startangle) <= self.tolerance:
                self.Input("Hammer", 0, 0)
            
            # slight delay between firing
            if self.reloadTime > 0:
                self.reloadTime -= 1
            
        return AI.SuperAI.Tick(self)

    def InvertHandler(self):
        # fire all weapons once per second (until we're upright!)
        while 1:
            for trigger in self.trigger2:
                self.Input(trigger, 0, 1)
            
            for i in range(0, 8):
                yield 0
                
    def LostComponent(self, id):
        # if we lose all our weapons, stop using the Engage tactic and switch to Shove
        if id in self.weapons: self.weapons.remove(id)
        
        if not self.weapons:
            tactic = [x for x in self.tactics if x.name == "Engage"]
            if len(tactic) > 0:
                self.tactics.remove(tactic[0])
                
                self.tactics.append(Tactics.Shove(self))
                self.tactics.append(Tactics.Charge(self))
            
        return AI.SuperAI.LostComponent(self, id)
                
    def DebugString(self, id, string):
        if self.debug:
            if id == 0: self.debug.get("line0").setText(string)
            elif id == 1: self.debug.get("line1").setText(string)
            elif id == 2: self.debug.get("line2").setText(string)
            elif id == 3: self.debug.get("line3").setText(string)
    
AI.register(Judge)
